cap log close
drop _all
log using "D:\Dropbox\hrs\wealthcouples\ADL\fertmarr_log.log", replace

use D:\Dropbox\hrs\wealthcouples\dataprep2_4states, clear
***********************************************************
**** Produce information on the number of children  ****
***********************************************************
xtset HHID wave
* Couples
tab child if hhstatus==3

* non-couples including newly dead (accounting for gaps)
tab child if hhstatus==2|hhstatus==1|(died==1&(L.hhstatus==2|L.hhstatus==1))|(died==1&(L2.hhstatus==2|L2.hhstatus==1))|(died==1&(L3.hhstatus==2|L3.hhstatus==1))|(died==1&(L4.hhstatus==2|L4.hhstatus==1))

*all - including new estates
tab child if hhstatus!=0|died==1
 
***********************************************************
**** Produce information on the number of never married  ****
*********************************************************** 

gen nevermarried_divorced =0
replace nevermarried_divorced=1 if manmarstat==5|manmarstat==8| lmanmarstat==5|lmanmarstat==8| womanmarstat==5|womanmarstat==8| lwomanmarstat==5|lwomanmarstat==8

sum nevermarried_divorced

 tab nevermarried_divorced
 
  tab nevermarried_divorced if hhstatus!=0|died==1

 
 collapse (max) nevermarried_divorced, by(HHID)
 
 tab nevermarried_divorced
 
log close